/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.entity.player;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.mixin.entity.player.IEntityPlayerMixin;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.constants.EnumAnimationStages;
import noppes.npcs.entity.data.DataAnimation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayer.class}, priority=499)
public class EntityPlayerMixin
implements IEntityPlayerMixin {
    @Mutable
    @Shadow
    protected BlockPos field_71077_c;
    @Unique
    public DataAnimation npcs$animation;

    @Inject(method={"attackTargetEntityWithCurrentItem"}, at={@At(value="HEAD")})
    public void npcs$attackTargetEntityWithCurrentItem(Entity targetEntity, CallbackInfo ci) {
        if (CustomNpcs.ShowCustomAnimation) {
            this.npcs$animation.tryRunAnimation(AnimationKind.ATTACKING);
        }
    }

    @Inject(method={"applyEntityAttributes"}, at={@At(value="TAIL")})
    protected void npcs$applyEntityAttributes(CallbackInfo ci) {
        if (this.npcs$animation == null) {
            this.npcs$animation = new DataAnimation((EntityLivingBase)((EntityPlayer)this));
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="TAIL")})
    protected void npcs$onUpdate(CallbackInfo ci) {
        if (this.npcs$animation != null) {
            this.npcs$animation.updateTime();
        }
    }

    @Inject(method={"jump"}, at={@At(value="TAIL")})
    public void npcs$jump(CallbackInfo ci) {
        this.npcs$animation.setJump(true);
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="TAIL")})
    public void npcs$onLivingUpdate(CallbackInfo ci) {
        if (CustomNpcs.ShowCustomAnimation) {
            EntityPlayer player = (EntityPlayer)this;
            if (this.npcs$animation.getJump() && player.field_70122_E && this.npcs$animation.getAnimationStage() != EnumAnimationStages.Started) {
                this.npcs$animation.setJump(false);
                if (this.npcs$animation.isAnimated(AnimationKind.JUMP)) {
                    this.npcs$animation.stopAnimation();
                }
            }
            if (!this.npcs$animation.getSwing() && player.field_70733_aJ > 0.0f) {
                AnimationConfig anim;
                this.npcs$animation.setSwing(true);
                if (!this.npcs$animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.AIM, AnimationKind.SHOOT) && (anim = this.npcs$animation.tryRunAnimation(AnimationKind.SWING)) != null) {
                    player.field_70733_aJ = 0.0f;
                    player.field_110158_av = 0;
                    player.field_70732_aI = 0.0f;
                    player.field_82175_bq = false;
                }
            } else if (this.npcs$animation.getSwing() && player.field_70733_aJ == 0.0f) {
                this.npcs$animation.setSwing(false);
            }
            this.npcs$animation.resetWalkAndStandAnimations();
        }
    }

    @Override
    public void npcs$setSpawnPos(BlockPos newSpawnPos) {
        this.field_71077_c = newSpawnPos;
    }

    @Override
    public DataAnimation npcs$getAnimation() {
        return this.npcs$animation;
    }
}

